'/***
'*time.h - definitions/declarations for time routines
'*
'*       Copyright (c) 1985-1997, Microsoft Corporation. All rights reserved.
'*
'*Purpose:
'*       This file has declarations of time routines and defines
'*       the structure returned by the localtime and gmtime routines and
'*       used by asctime.
'*       [ANSI/System V]
'*
'*       [Public]
'*
'****/

#If Not %Def(%TIME_INC)
   %TIME_INC = 1

'/*
' * Currently, all MS C compilers for Win32 platforms default to 8 byte
' * alignment.
' */
'#pragma pack(push,8)

'typedef unsigned short wchar_t;
'typedef long time_t;        /* time value */
'typedef long clock_t;
'typedef unsigned int size_t;

#If Not %Def(%TM_DEFINED)
%TM_DEFINED = 1
Type tm
   tm_sec   As Long   ' int /* seconds after the minute - [0,59] */
   tm_min   As Long   ' int /* minutes after the hour - [0,59] */
   tm_hour  As Long   ' int /* hours since midnight - [0,23] */
   tm_mday  As Long   ' int /* day of the month - [1,31] */
   tm_mon   As Long   ' int /* months since January - [0,11] */
   tm_year  As Long   ' int /* years since 1900 */
   tm_wday  As Long   ' int /* days since Sunday - [0,6] */
   tm_yday  As Long   ' int /* days since January 1 - [0,365] */
   tm_isdst As Long   ' int /* daylight savings time flag */
End Type
#EndIf


'/* Clock ticks macro - ANSI version */

%CLOCKS_PER_SEC = 1000


'/* Extern declarations for the global variables used by the ctime family of
' * routines.
' */

'/* non-zero if daylight savings time is used */
'_CRTIMP extern int _daylight;

Function pb_daylight () As Long
   Local hLib As Dword
   Local pdaylight As Long Ptr
   hLib = LoadLibrary("msvcrt.dll")
   If hLib Then
      pdaylight = GetProcAddress(hLib, "_daylight")
      If pdaylight Then Function = @pdaylight
      FreeLibrary hLib
   End If
End Function

'/* offset for Daylight Saving Time */
'_CRTIMP extern long _dstbias;

Function pb_dstbias () As Long
   Local hLib As Dword
   Local pdstbias As Long Ptr
   hLib = LoadLibrary("msvcrt.dll")
   If hLib Then
      pdstbias = GetProcAddress(hLib, "_dstbias")
      If pdstbias Then Function = @pdstbias
      FreeLibrary hLib
   End If
End Function

'/* difference in seconds between GMT and local time */
'_CRTIMP extern long _timezone;

Function pb_timezone () As Long
   Local hLib As Dword
   Local ptimezone As Long Ptr
   hLib = LoadLibrary("msvcrt.dll")
   If hLib Then
      ptimezone = GetProcAddress(hLib, "_timezone")
      If ptimezone Then Function = @ptimezone
      FreeLibrary hLib
   End If
End Function

'/* standard/daylight savings time zone names */
'_CRTIMP extern char * _tzname[2];

Type tzname_struct
   PST As Asciiz Ptr
   PDT As Asciiz Ptr
End Type

Sub pb_tzname (ByRef rgnames() As String)
   If UBound(rgnames) - LBound(rgnames) + 1 <> 2 Then Exit Sub
   Local hLib As Dword
   Dim ptzname As tzname_struct Ptr
   hLib = LoadLibrary("msvcrt.dll")
   If hLib Then
      ptzname = GetProcAddress(hLib, "_tzname")
      If ptzname Then
         rgnames(LBound(rgnames)) = @ptzname.@PST
         rgnames(UBound(rgnames)) = @ptzname.@PDT
      End If
      FreeLibrary hLib
   End If
End Sub

'/* Function prototypes */

'_CRTIMP char * __cdecl asctime(const struct tm *);
Declare Function asctime CDecl Lib "msvcrt.dll" Alias "asctime" ( _
   ByRef tm _                               ' const struct tm *
   ) As Dword                               ' char *

Function pb_asctime (ByRef timeptr_ As tm) As String
   Local pchar_ As Asciiz Ptr
   pchar_ = asctime(timeptr_)
   If pchar_ Then Function = @pchar_
End Function

'_CRTIMP char * __cdecl ctime(const time_t *);
Declare Function ctime CDecl Lib "msvcrt.dll" Alias "ctime" ( _
   ByRef Long _                             ' const time_t *
   ) As Dword                               ' char *

Function pb_ctime (ByRef timer_ As Long) As String
   Local pchar_ As Asciiz Ptr
   pchar_ = ctime(timer_)
   If pchar_ Then Function = @pchar_
End Function

'_CRTIMP clock_t __cdecl clock(void);
Declare Function clock CDecl Lib "msvcrt.dll" Alias "clock" ( _
   ) As Long                                ' clock_t

'_CRTIMP double __cdecl difftime(time_t, time_t);
Declare Function difftime CDecl Lib "msvcrt.dll" Alias "difftime" ( _
   ByVal Long, _                            ' time_t timer1
   ByVal Long _                             ' time_t timer0
   ) As Double                              ' double

'_CRTIMP struct tm * __cdecl gmtime(const time_t *);
Declare Function gmtime CDecl Lib "msvcrt.dll" Alias "gmtime" ( _
   ByRef Long _                             ' const time_t *
   ) As Dword                               ' tm *

Sub pb_gmtime (ByRef timer_ As Long, ByRef tm_ As tm)
   Local ptm As tm Ptr
   ptm = gmtime(timer_)
   If IsFalse ptm Then Exit Sub
   tm_ = @ptm
End Sub

'_CRTIMP struct tm * __cdecl localtime(const time_t *);
Declare Function localtime CDecl Lib "msvcrt.dll" Alias "localtime" ( _
   ByRef Long _                             ' const time_t *
   ) As Dword                               ' tm *

Sub pb_localtime (ByRef timer_ As Long, ByRef tm_ As tm)
   Local ptm As tm Ptr
   ptm = localtime(timer_)
   If IsFalse ptm Then Exit Sub
   tm_ = @ptm
End Sub

'_CRTIMP time_t __cdecl mktime(struct tm *);
Declare Function mktime CDecl Lib "msvcrt.dll" Alias "mktime" ( _
   ByRef tm _                               ' struct tm *
   ) As Long                                ' time_t

'_CRTIMP size_t __cdecl strftime(char *, size_t, const char *,
'        const struct tm *);
Declare Function strftime CDecl Lib "msvcrt.dll" Alias "strftime" ( _
   ByRef Asciiz, _                          ' char *strDest
   ByVal Dword, _                           ' size_t maxsize
   ByRef Asciiz, _                          ' const char *format
   ByRef tm _                               ' const struct tm *timeptr
   ) As Dword                               ' size_t

Function pb_strftime (ByRef szFormat As Asciiz, ByRef tm_ As tm) As String
   Local cb As Dword
   Local szDest As Asciiz * 260
   cb = strftime(szDest, SizeOf(szDest), szFormat, tm_)
   If cb Then Function = szDest
End Function

'_CRTIMP char * __cdecl _strdate(char *);
Declare Function strdate CDecl Lib "msvcrt.dll" Alias "_strdate" ( _
   ByRef Asciiz _                           ' char *datestr
   ) As Dword                               ' char *

Function pb_strdate (ByRef szdatestr As Asciiz) As String
   Local pchar_ As Asciiz Ptr
   pchar_ = strdate(szdatestr)
   If pchar_ Then Function = @pchar_
End Function

'_CRTIMP char * __cdecl _strtime(char *);
Declare Function strtime CDecl Lib "msvcrt.dll" Alias "_strtime" ( _
   ByRef Asciiz _                           ' char *timestr
   ) As Dword                               ' char *

Function pb_strtime (ByRef sztimestr As Asciiz) As String
   Local pchar_ As Asciiz Ptr
   pchar_ = strtime(sztimestr)
   If pchar_ Then Function = @pchar_
End Function

'_CRTIMP time_t __cdecl time(time_t *);
Declare Function time CDecl Lib "msvcrt.dll" Alias "time" ( _
   ByRef Long _                             ' time_t *timer
   ) As Long                                ' time_t

'_CRTIMP void __cdecl _tzset(void);
Declare Sub tzset CDecl Lib "msvcrt.dll" Alias "_tzset" ()

'/* --------- The following functions are OBSOLETE --------- */
'/* The Win32 API GetLocalTime and SetLocalTime should be used instead. */
'unsigned __cdecl _getsystime(struct tm *);
'unsigned __cdecl _setsystime(struct tm *, unsigned);
'/* --------- The preceding functions are OBSOLETE --------- */


'/* wide function prototypes, also declared in wchar.h */

#If Not %Def(%WTIME_DEFINED)
    %WTIME_DEFINED = 1

'_CRTIMP wchar_t * __cdecl _wasctime(const struct tm *);

Declare Function wasctime CDecl Lib "msvcrt.dll" Alias "_wasctime" ( _
   ByRef tm _                               ' const struct tm *
   ) As Dword                               ' wchar_t *

Function pb_wasctime (ByRef timeptr_ As tm) As String
   Local pwchar_ As Dword
   Local nLen As Dword
   pwchar_ = wasctime(timeptr_)
   If pwchar_ Then
      nLen = Lstrlenw(ByVal pwchar_)
      If nLen Then Function = Peek$(pwchar_, nLen * 2)
   End If
End Function

'_CRTIMP wchar_t * __cdecl _wctime(const time_t *);
Declare Function wctime CDecl Lib "msvcrt.dll" Alias "_wctime" ( _
   ByRef Long _                             ' const time_t *
   ) As Dword                               ' wchar_t *

Function pb_wctime (ByRef timer_ As Long) As String
   Local pwchar_ As Dword
   Local nLen As Dword
   pwchar_ = wctime(timer_)
   If pwchar_ Then
      nLen = Lstrlenw(ByVal pwchar_)
      If nLen Then Function = Peek$(pwchar_, nLen * 2)
   End If
End Function

'_CRTIMP size_t __cdecl wcsftime(wchar_t *, size_t, const wchar_t *,
'        const struct tm *);

Declare Function wcsftime CDecl Lib "msvcrt.dll" Alias "wcsftime" ( _
   ByVal Dword, _                           ' wchar_t *strDest
   ByVal Dword, _                           ' size_t maxsize
   ByVal Dword, _                           ' const wchar_t *format
   ByRef tm _                               ' const struct tm *timeptr
   ) As Dword                               ' size_t

Function pb_wcsftime (ByVal strFormat As String, ByRef tm_ As tm) As String
   Local cb As Dword
   Local strDest As String
   strDest = Space$(260 * 2)
   cb = wcsftime(StrPtr(strDest), Len(strDest), StrPtr(strFormat), tm_)
   If cb Then Function = Left$(strDest, cb * 2)
End Function

'_CRTIMP wchar_t * __cdecl _wstrdate(wchar_t *);
Declare Function wstrdate CDecl Lib "msvcrt.dll" Alias "_wstrdate" ( _
   ByVal Dword _                            ' wchar_t *datestr
   ) As Dword                               ' wchar_t *

Function pb_wstrdate (ByVal wszdatestr As String) As String
   Local pwchar_ As Dword
   Local nLen As Dword
   pwchar_ = wstrdate(StrPtr(wszdatestr))
   If pwchar_ Then
      nLen = Lstrlenw(ByVal pwchar_)
      If nLen Then Function = Peek$(pwchar_, nLen * 2)
   End If
End Function

'_CRTIMP wchar_t * __cdecl _wstrtime(wchar_t *);
Declare Function wstrtime CDecl Lib "msvcrt.dll" Alias "_wstrtime" ( _
   ByVal Dword _                            ' wchar_t *timestr
   ) As Dword                               ' wchar_t *

Function pb_wstrtime (ByVal wsztimestr As String) As String
   Local pwchar_ As Dword
   Local nLen As Dword
   pwchar_ = wstrtime(StrPtr(wsztimestr))
   If pwchar_ Then
      nLen = Lstrlenw(ByVal pwchar_)
      If nLen Then Function = Peek$(pwchar_, nLen * 2)
   End If
End Function

#EndIf   ' #IF NOT %DEF(%WTIME_DEFINED)

'#pragma pack(pop)

#EndIf   ' #IF NOT %DEF(%TIME_INC)